/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.graphic.FontChange;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HtmlColor;

class ColorAndSizeChange
implements FontChange {
    static final Pattern colorPattern = Pattern.compile("(?i)color\\s*=\\s*\"?(#[0-9a-fA-F]{6}|\\w+)\"?");
    static final Pattern sizePattern = Pattern.compile("(?i)size\\s*=\\s*\"?(\\d+)\"?");
    private final HtmlColor color;
    private final Integer size;

    ColorAndSizeChange(String string) {
        Matcher matcher = colorPattern.matcher(string);
        this.color = matcher.find() ? HtmlColor.getColorIfValid(matcher.group(1)) : null;
        Matcher matcher2 = sizePattern.matcher(string);
        this.size = matcher2.find() ? new Integer(matcher2.group(1)) : null;
    }

    HtmlColor getColor() {
        return this.color;
    }

    Integer getSize() {
        return this.size;
    }

    public FontConfiguration apply(FontConfiguration fontConfiguration) {
        FontConfiguration fontConfiguration2 = fontConfiguration;
        if (this.color != null) {
            fontConfiguration2 = fontConfiguration2.changeColor(this.color);
        }
        if (this.size != null) {
            fontConfiguration2 = fontConfiguration2.changeSize(this.size.intValue());
        }
        return fontConfiguration2;
    }
}

